
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

//package simparm.twiddler;

import java.io.*;


class ConfigEntryLong extends ConfigEntryNumber {

	private long value;
	private long increment;
	private boolean hasmin;
	private long minvalue;
	private boolean hasmax;
	private long maxvalue;
	private boolean unsigned;

	public ConfigEntryLong() {
		super();
		value = 0;
		increment = 0;
		setNoMin();
		setNoMax();
	}

	public ConfigEntryLong(boolean unsigned) {
		this();
		this.unsigned = unsigned;
	}

	public boolean setValue(String value, boolean doprint, boolean updatefield) {
		try {
			setValue(Long.parseLong(value), doprint, updatefield);
			return true;
		} catch (NumberFormatException ex) {
			return false;
		}
	}

	public void setValue(long newvalue, boolean doprint, boolean updatefield) {
		if (hasmin && newvalue < minvalue) {
			newvalue = minvalue;
		}
		if (hasmax && newvalue > maxvalue) {
			newvalue = maxvalue;
		}
		if (unsigned && newvalue < 0) {
			newvalue = 0;
		}

		if (value != newvalue) {
			value = newvalue;
			if (doprint) {
				doPrint();
			}
		}
		if (updatefield) {
			textField.setText(Long.toString(value));
		}
	}

	public boolean setValueFromInputStream(String word) {
		return setValue(word, false, true);
	}

	public void adjustValue(int amount) {
		setValue(value - amount * increment, true, true);
	}

	public void setMin(long min) {
		hasmin = true;
		if (unsigned && min < 0) {
			min = 0;
		}
		minvalue = min;
	}

	public void setNoMin() {
		hasmin = false;
	}

	public void setMax(long max) {
		hasmax = true;
		if (unsigned && max < 0) {
			max = 0;
		}
		maxvalue = max;
	}

	public void setNoMax() {
		hasmax = false;
	}

	public void setIncrement(long increment) {
		this.increment = increment;
	}

	public void doSpecificPrint(PrintStream out) {
		out.print(value);
	}

	public void readDefinitionSpecific(BufferedReader input) throws IOException {
		setValue(readLong(input, "value"), false, true);
		setIncrement(readLong(input, "increment"));
		hasmin = readBoolean(input, "hasmin");
		//System.err.println("hasmin = " + hasmin);
		if (hasmin) {
			setMin(readLong(input, "min"));
		} else {
			setNoMin();
		}
		hasmax = readBoolean(input, "hasmax");
		if (hasmax) {
			setMax(readLong(input, "max"));
		} else {
			setNoMax();
		}
	}

}

