
// SimParm: Simple and flexible C++ configuration framework
// Copyright (C) 2007 Australian National University
// 
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
// 
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// 
// Contact:
// Kevin Pulo
// kevin.pulo@anu.edu.au
// Leonard Huxley Bldg 56
// Australian National University, ACT, 0200, Australia

//package simparm.twiddler;

import java.io.*;


class ConfigEntryDouble extends ConfigEntryNumber {

	private double value;
	private double increment;
	private boolean hasmin;
	private double minvalue;
	private boolean hasmax;
	private double maxvalue;

	public ConfigEntryDouble() {
		super();
		value = 0.0;
		increment = 0.0;
		setNoMin();
		setNoMax();
	}

	public boolean setValue(String value, boolean doprint, boolean updatefield) {
		try {
			setValue(Double.parseDouble(value), doprint, updatefield);
			return true;
		} catch (NumberFormatException ex) {
			return false;
		}
	}

	public void setValue(double newvalue, boolean doprint, boolean updatefield) {
		//System.err.println("ConfigEntryDouble.setValue()");
		//System.err.println("newvalue = " + newvalue);
		//System.err.println("updatefield = " + updatefield);
		//System.err.println("value = " + value);
		if (hasmin && newvalue < minvalue) {
			newvalue = minvalue;
		}
		if (hasmax && newvalue > maxvalue) {
			newvalue = maxvalue;
		}

		if (value != newvalue) {
			value = newvalue;
			if (doprint) {
				doPrint();
			}
		}
		if (updatefield) {
			//textField.setText(Double.toString(value));
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PrintStream print = new PrintStream(baos);
			print.format("%f", value);
			textField.setText(baos.toString());
		}
	}

	public boolean setValueFromInputStream(String word) {
		return setValue(word, false, true);
	}

	public void adjustValue(int amount) {
		//System.err.println("ConfigEntryDouble.adjustValue(amount = " + amount + ")");
		setValue(value - amount * increment, true, true);
	}

	public void setMin(double min) {
		hasmin = true;
		minvalue = min;
	}

	public void setNoMin() {
		hasmin = false;
	}

	public void setMax(double max) {
		hasmax = true;
		maxvalue = max;
	}

	public void setNoMax() {
		hasmax = false;
	}

	public void setIncrement(double increment) {
		this.increment = increment;
	}

	public void doSpecificPrint(PrintStream out) {
		//out.print(value);
		out.format("%f", value);
	}

	public void readDefinitionSpecific(BufferedReader input) throws IOException {
		setValue(readDouble(input, "value"), false, true);
		setIncrement(readDouble(input, "increment"));
		hasmin = readBoolean(input, "hasmin");
		//System.err.println("hasmin = " + hasmin);
		if (hasmin) {
			setMin(readDouble(input, "min"));
		} else {
			setNoMin();
		}
		hasmax = readBoolean(input, "hasmax");
		if (hasmax) {
			setMax(readDouble(input, "max"));
		} else {
			setNoMax();
		}
	}

}

