/*******************************************************************************
+
+	cluster_test.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
+	$Id: cluster_test.cc,v 1.4 2000/05/28 11:31:19 kev Exp kev $
+
*******************************************************************************/

#include "cluster_test.hh"

static const char *rcsid = "$Id: cluster_test.cc,v 1.4 2000/05/28 11:31:19 kev Exp kev $";
static const char *rcsrevision = "$Revision: 1.4 $";


void cluster_test_ascending(int k) {
	point p;
	list<point> L;
	int i;

	L = T.points();
	clusters.resize(L.length());
	i = 0;
	forall(p, L) {
		clusters[i].rep = p;
		clusters[i].append(p);
		i++;
	}
}


void cluster_test_single(int k) {
	point p;
	list<point> L;
	
	L = T.points();
	clusters.resize(1);
	forall(p, L) {
		clusters[0].append(p);
	}
	clusters[0].rep = clusters[0].meanPoint();
}


void cluster_test_cheat(int k) {
	point p;
	Cluster c;
	list<point> L = T.points();
	int numClusters = 0;
	int i;

	forall(p, L) {
		i = -1;
		i = atoi(annotation[annotation.lookup(p)]);
		if (i < 0) {
			outliers.append(p);
		} else {
			while (i >= numClusters) {
				(*debug) << "CREATING NEW CLUSTER: " << numClusters << endl;
				// Create it
				Cluster *cp;
				cp = new Cluster();
				clusters.resize(clusters.size() + 1);
				clusters[clusters.size() - 1] = *cp;
				numClusters++;
			}

			clusters[i].append(p);
		}
	}

	// Find the representatives of the clusters.
	for (i = clusters.low(); i <= clusters.high(); i++) {
		clusters[i].rep = clusters[i].meanPoint();
	}
}



