/*******************************************************************************
+
+	cluster_tb.cc
+
+   Copyright (C) 2000
+	Kevin Pulo, kev@hons.cs.usyd.edu.au.
+	Garrick Welsh, gaz@hons.cs.usyd.edu.au.
+
+	This program is free software; you can redistribute it and/or modify
+	it under the terms of the GNU General Public License as published by
+	the Free Software Foundation; either version 2 of the License, or
+	(at your option) any later version.
+
+	This program is distributed in the hope that it will be useful,
+	but WITHOUT ANY WARRANTY; without even the implied warranty of
+	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
+	GNU General Public License for more details.
+
+	You should have received a copy of the GNU General Public License
+	along with this program; if not, write to the Free Software
+	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
+
+	$Id: cluster_tb.cc,v 1.3 2000/05/26 13:01:11 kev Exp $
+
*******************************************************************************/

#include "cluster_tb.hh"


static const char *rcsid = "$Id: cluster_tb.cc,v 1.3 2000/05/26 13:01:11 kev Exp $";
static const char *rcsrevision = "$Revision: 1.3 $";


static double globalMC = 0.0;


static void debugPrintClusters() {
	int i;
	int clustnum = 0;
	point p;

	for (i = clusters.low(); i <= clusters.high(); i++) {
		Cluster &c = clusters[i];
		list<point> &pts = c.getList();
		(*debug) << c.rep << endl;
		forall(p, pts) {
			(*debug) << clustnum << " " << p << " " << annotation.access(p) << endl;
		}
		clustnum++;
		(*debug) << endl;
	}
}


static point findClusterRepresentative(Cluster &c)
{
	//assert(c.getList().length() > 0);
	if (c.getList().length() <= 0) {
		// Unchanged.
		return c.rep;
	} else {
		return c.meanPoint();
	}
}


static Cluster &findClosestRepresentative(point p)
{
	int i;

	//assert(clusters.size() > 0);

	int closest = 0;
	double d = p.sqr_dist(clusters[closest].rep);
	for (i = clusters.low(); i <= clusters.high(); i++) {
		Cluster &c = clusters[i];
		double d2 = p.sqr_dist(c.rep);
		if (d2 < d) {
			d = d2;
			closest = i;
		}
	}
	globalMC += sqrt(d);
	return clusters[closest];
}

static void findAllClosestRepresentatives() {
	point p;
	list<point> points = T.points();

	forall(p, points) {
		Cluster &c = findClosestRepresentative(p);
		//list<point> &L = c.getList();
		//(*debug) << "cluster length: before: " << L.length();
		c.append(p);
		//(*debug) << " after: " << L.length() << endl;
	}
}


static void clearClusteringPoints() {
	int i;

	// Clear the contents of each cluster in preparation for the new clustering.
	for (i = clusters.low(); i <= clusters.high(); i++) {
		Cluster &c = clusters[i];
		c.getList().clear();
	}
}


void cluster_tb(int k) {
	int i;
	point p;
	list<point> points = T.points();
	array<point> oldReps;
	list_item l;
	list_item firstl;
	double MC;
	bool algorithmFinished = false;


	if (k > points.length()) {
		return;
	}

	// Create k clusters.
	clusters.resize(k);

	// Get the initial k representatives.
	points.permute();
	l = points.first();
	for (i = clusters.low(); i <= clusters.high(); i++) {
		clusters[i].rep = points.contents(l);
		l = points.succ(l);
	}

	// Shuffle the points again.
	points.permute();
	l = points.first();
	firstl = l;

	while (true) {
		//debugPrintClusters();


		clearClusteringPoints();


		// Recompute the clusterings based on these cluster representatives.
		MC = globalMC;
		(*debug) << "MC before = " << MC << endl;
		findAllClosestRepresentatives();
		MC = globalMC;
		(*debug) << "MC after = " << MC << endl;


		// Okay, now scan through points (using the variable l), for each
		// non-representative point, consider swapping it with every
		// representative.  For each consideration, calculate MC', and if
		// the minimum of these is < MC, then do the corresponding swap.
		while (true) {
			p = points.contents(l);
			if (findClosestRepresentative(p).rep != p) {
				// Weird way of finding out if p is not a representative.

				// Swap this point with each of the representatives.
				// For each swap, find MC and update things if it's the smallest.
				int minIndex = 0;
				double minMCdash = -1.0;
				for (i = clusters.low(); i <= clusters.high(); i++) {
					// Swap the points.
					point oldRep = clusters[i].rep;
					clusters[i].rep = p;

					clearClusteringPoints();

					// Find the clustering (and therefore MCdash).
					globalMC = 0.0;
					findAllClosestRepresentatives();
					double MCdash = globalMC;

					// Update the minimum records if required.
					(*debug) << i << ": " << MCdash << endl;
					if ( (minMCdash == -1.0) || (MCdash < minMCdash) ) {
						(*debug) << "new minimum." << endl;
						minMCdash = MCdash;
						minIndex = i;
					}

					// Swap the points back to their original state.
					// ie. Restore the old rep.
					clusters[i].rep = oldRep;
				}
				(*debug) << "minIndex = " << minIndex << " minMCdash = " << minMCdash << endl;

				if (minMCdash < MC) {
					(*debug) << "minMCdash < MC  !!!" << endl;
					// Swap p with the minIndex-th representative.
					clusters[minIndex].rep = p;
					// Break, we have a new and better solution.
					break;
				}
				clearClusteringPoints();

				// Recalculate the clustering, because all of our swapping
				// then testing has destroyed the current clustering.
				findAllClosestRepresentatives();
			}

			l = points.cyclic_succ(l);

			if (l == firstl) {
				// Break BOTH levels of while loops - this is the end of the
				// whole algorithm.
				algorithmFinished = true;
				break;
			}
		}

		if (algorithmFinished) {
			break;
		}
	}

}


